using System;
using Server;
using Server.Network;
using Server.Prompts;
using Server.Targeting;

namespace Server.Items
{
    public class LevelHuntersHeaddress : LevelDeerMask
	{
		private int m_Bonus = 0;
		private int m_Version;
		
		[CommandProperty(AccessLevel.GameMaster)]
		public int Bonus { get { return m_Bonus; } set { m_Bonus = value; InvalidateProperties(); } }
		
		[CommandProperty(AccessLevel.GameMaster)]
		public int Version { get { return m_Version; } set { m_Version = value; InvalidateProperties(); } }
		
		public override int LabelNumber{ get{ return 1061595; } } // Hunter's Headdress
		
		public override int ArtifactRarity{ get{ return (m_Version < 2) ? 11 : 75; } }
		
		public override int BaseColdResistance{ get{ return 23; } }
		
		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }
		
		[Constructable]
		public LevelHuntersHeaddress()
		{
			Hue = 0x594;
			
			SkillBonuses.SetValues( 0, SkillName.Archery, 20 );
			
			Attributes.BonusDex = 15;
			Attributes.NightSight = 1;
			Attributes.AttackChance = 15;
			Version = 2;
		}
		
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
			if (m_Version > 1)
				list.Add( "<basefont color=#9999FF>Ability protection charges: " + ( m_Bonus / 1000 ).ToString() + "<basefont color=White>" );
		}
		
		public override void OnDoubleClick( Mobile from )
		{
			if (m_Version < 2)
				return;
			
			if (!IsChildOf(from.Backpack))
			{
				from.SendLocalizedMessage(1042001); // That must be in your pack for you to use it.
				return;
			}
			
			from.SendMessage( "Zamer zlataky (1 nabiti = 1000gp)" );
			from.Target = new InternalTarget( this );
		}
		
		public LevelHuntersHeaddress( Serial serial ) : base( serial )
		{
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			
			writer.Write( (int) 2 );
			
			//ver 2
			writer.Write((int)m_Bonus);
			writer.Write((int)m_Version);
		}
		
		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize( reader );
			
			int version = reader.ReadInt();
			switch ( version )
			{
				case 2:
				{
					m_Bonus = reader.ReadInt();
					m_Version = reader.ReadInt();
					goto case 1;
				}
				case 1:
				{
					goto case 0;
				}
				case 0:
				{
					break;
				}
				
				if (version < 2)
					m_Version = 0;
			}
		}
		
		private class InternalTarget : Target
		{
			private LevelHuntersHeaddress m_Item;
			
			public InternalTarget( LevelHuntersHeaddress levitem ) : base( 1, false, TargetFlags.None )
			{
				m_Item = levitem;
			}
			
			protected override void OnTarget( Mobile from, object target )
			{
				if ( from == null || m_Item == null || m_Item.Deleted || target is StaticTarget || target is LandTarget )
					return;
				
				if ( !( target is Gold ) )
				{
					from.SendMessage( "Musis zamerit zlataky!" );
					return;
				}
				
				Item tokens = (Item) target;
				
				if ( tokens == null || m_Item.Version < 2)
					from.SendMessage( "Neocekavana chyba (ERROR 01)!" );
				else if( !tokens.IsChildOf( from.Backpack ) )
					from.SendMessage( "Musis mit mince u sebe" );
				else if ( tokens.Amount < 1000 )
					from.SendMessage( "Minimalni mnozstvi minci je 1000" );
				else
				{
					int need = ( tokens.Amount > 30000 ) ? 30000 : tokens.Amount;
					
					m_Item.Bonus += need;
					tokens.Consume( need );
					from.PlaySound( 501 );
					from.FixedParticles( 14120, 1, 10, 0x1F78, tokens.Hue, 5, EffectLayer.Waist );
					from.SendMessage("Predmet absorboval {0}gp.", need );
					from.Target = new InternalTarget( m_Item );
				}
			}
		}
	}
}